PY3TEST()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun

    smb/common/pgswim/pytest
    smb/common/testing_utils

    maps_adv/common/lasagna/pytest
    maps_adv/geosmb/clients/bvm/pytest
    maps_adv/geosmb/clients/cdp/pytest
    maps_adv/geosmb/clients/geosearch/pytest
    maps_adv/geosmb/marksman/server
)

SRCDIR(maps_adv/geosmb/marksman/server)

PY_SRCS(
    __init__.py
    api/__init__.py
    conftest.py
    data_manager/__init__.py
    domain/__init__.py
    factory.py
    tasks/__init__.py
)

TEST_SRCS(
    api/test_add_business.py
    api/test_list_business_segments_data.py
    api/test_ping.py
    data_manager/test_add_business.py
    data_manager/test_add_business_segment.py
    data_manager/test_list_biz_ids.py
    data_manager/test_list_business_segments_data.py
    domain/test_add_business.py
    domain/test_list_business_segments_data.py
    domain/test_sync_businesses_segments.py
    domain/test_sync_segments_sizes.py
    data_manager/test_update_segments_sizes.py
    tasks/test_cdp_users_sync_task.py
    tasks/test_tasks_warden_integration.py
)

ENV(DATABASE_URL_FOR_TESTS=postgresql://marksman:marksman@localhost:5433/marksman?master_as_replica=true)
INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
)

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all
    dns:dns64
)

CONFTEST_LOAD_POLICY_LOCAL()
NO_DOCTESTS()

END()
