import argparse

from maps_adv.common.config_loader import ConfigLoader, Option, converters
from maps_adv.common.lasagna import setup_logging
from maps_adv.geosmb.notification_bot.server.lib import Application

config = ConfigLoader(
    Option("TVM_DAEMON_URL", load_from="DEPLOY_TVM_TOOL_URL"),
    Option("TVM_TOKEN", load_from="TVMTOOL_LOCAL_AUTHTOKEN"),
    Option("BOT_TOKEN"),
    Option("CUSTOM_RATE_LIMIT", default=5, converter=int),
    Option("BOT_ADMINS", default=(), converter=converters.Tuple()),
    Option("WEBHOOK_URL_PATH"),
    Option("WEBHOOK_URL"),
    Option("TUNER_URL", default=None),
)

arg_parser = argparse.ArgumentParser("NotificationBot")
arg_parser.add_argument("--host")
arg_parser.add_argument("--port", type=int)


def main():
    setup_logging()
    config.init()

    args = arg_parser.parse_args()

    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
