from aiohttp import web

from maps_adv.geosmb.notification_bot.server.lib.domain import Domain

from .resources import Resources

__all__ = ["create"]


def create(domain: Domain, webhook_path: str) -> web.Application:
    api = web.Application()

    resources = Resources(domain)

    api.add_routes(
        [
            web.get("/ping", resources.ping),
            web.post(webhook_path, resources.handle_webhook),
            web.post("/api/send-message", resources.send_message),
        ]
    )

    return api
