from marshmallow import Schema, fields, validate
import telebot

from maps_adv.geosmb.notification_bot.server.lib.domain import Domain


class SendMessageInputSchema(Schema):
    user_id = fields.Integer(required=True, validate=[validate.Range(min=1)])
    message = fields.String(required=True, validate=[validate.Length(min=1)])


class SendMessageOutputSchema(Schema):
    user_id = fields.Integer(required=True, validate=[validate.Range(min=1)])


class ApiProvider:
    _domain: Domain

    def __init__(self, domain: Domain):
        self._domain = domain

    async def send_message(self, data):
        message_data = SendMessageInputSchema().load(data).data
        result = await self._domain.send_message(**message_data)
        return SendMessageOutputSchema().dump(result).data

    async def handle_webhook(self, data):
        update = telebot.types.Update.de_json(data)
        await self._domain.process_updates(update)
