from aiohttp.web import Request, Response, json_response

from maps_adv.geosmb.notification_bot.server.lib.domain import Domain

from .providers import ApiProvider


class Resources:
    _provider: ApiProvider

    def __init__(self, domain: Domain):
        self._provider = ApiProvider(domain)

    async def ping(self, _: Request) -> Response:
        return Response(status=204)

    async def send_message(self, request: Request) -> Response:
        body = await request.json()

        result = await self._provider.send_message(data=body)

        return json_response(result, status=200)

    async def handle_webhook(self, request: Request) -> Response:
        body = await request.json()

        await self._provider.handle_webhook(data=body)

        return Response(status=200)
