from telebot.async_telebot import AsyncTeleBot

from maps_adv.geosmb.tuner.client import TunerClient

from .help import handle_help
from .start import handle_start
from .echo import handle_echo
from .stop import handle_stop


__all__ = [
    "register_user_commands",
]


def register_user_commands(bot: AsyncTeleBot, tuner_client: TunerClient):
    bot.register_message_handler(
        handle_help,
        commands=['help'],
        pass_bot=True
    )
    bot.register_message_handler(
        handle_start(bot=bot, tuner_client=tuner_client),
        commands=['start']
    )
    bot.register_message_handler(
        handle_stop(bot=bot, tuner_client=tuner_client),
        commands=["stop"]
    )
    bot.register_message_handler(
        handle_echo,
        pass_bot=True
    )
