import logging

from telebot import types
from telebot.async_telebot import AsyncTeleBot

from maps_adv.geosmb.notification_bot.server.lib.bot.utils.answers import texts
from maps_adv.geosmb.tuner.client import TunerClient


def handle_start(bot: AsyncTeleBot, tuner_client: TunerClient):
    async def handle_message(message: types.Message):
        if await bot.get_state(message.from_user.id) != 'flood':
            logging.getLogger(__name__).info(f'Command_Start {message.from_user.id}')
            await tuner_client.update_telegram_user(message.from_user.id, message.from_user.username)
            await bot.send_message(message.chat.id, texts['start'].format(login=message.from_user.username))
    return handle_message
