import logging

from telebot import types
from telebot.async_telebot import AsyncTeleBot

from maps_adv.geosmb.notification_bot.server.lib.bot.utils.answers import texts
from maps_adv.geosmb.tuner.client import TunerClient


def handle_stop(bot: AsyncTeleBot, tuner_client: TunerClient):
    async def handle_message(message: types.Message):
        if await bot.get_state(message.from_user.id) != 'flood':
            logging.getLogger(__name__).info(f'Command_Stop {message.from_user.id}')
            await tuner_client.delete_telegram_user(message.from_user.id)
            await bot.send_message(message.chat.id, texts['stop'])
    return handle_message
