from telebot.handler_backends import BaseMiddleware
from telebot.async_telebot import AsyncTeleBot
from maps_adv.geosmb.notification_bot.server.lib.bot.utils.answers import texts


class AntifloodEcho(BaseMiddleware):
    def __init__(self, limit, bot: AsyncTeleBot) -> None:
        self.last_time = {}
        self.limit = limit
        self.update_types = ['message']
        self.bot = bot

    async def pre_process(self, message, data):
        if message.from_user.id not in self.last_time:
            self.last_time[message.from_user.id] = message.date
            return
        if message.date - self.last_time[message.from_user.id] <= self.limit:
            await self.bot.send_message(message.chat.id, texts['flood'])
            await self.bot.set_state(message.from_user.id, 'flood')
            return
        await self.bot.delete_state(message.from_user.id)
        self.last_time[message.from_user.id] = message.date

    async def post_process(self, message, data, exception):
        pass
