import logging
from typing import Tuple
from telebot.async_telebot import AsyncTeleBot

from maps_adv.geosmb.notification_bot.server.lib.bot.utils.antiflood import antiflood


async def notify_admins(bot: AsyncTeleBot, admins: Tuple[str] = ()):
    logging.getLogger(__name__).info(f"Отправляем уведомления администраторам: {admins}")
    for admin in admins:
        try:
            await antiflood(bot.send_message, admin, "Бот запущен и готов к работе")
        except Exception as e:
            logging.getLogger(__name__).info(f"Не удалось отправить уведомление администратору {admin} - {e}")
