PY3_LIBRARY()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/marshmallow/py2
    contrib/python/marshmallow-enum/py2

    yql/library/python

    smb/common/multiruntime
    smb/common/pgswim

    maps_adv/config_loader
    maps_adv/common/helpers
    maps_adv/common/lasagna
    maps_adv/common/protomallow
    maps_adv/common/yt_utils
    maps_adv/geosmb/promoter/proto
)

PY_SRCS(
    lib/api/__init__.py
    lib/api/middlewares.py
    lib/api/providers.py
    lib/api/resources.py
    lib/data_manager/__init__.py
    lib/data_manager/sqls/__init__.py
    lib/data_manager/sqls/events.py
    lib/data_manager/sqls/leads.py
    lib/data_manager/sqls/segments.py
    lib/data_manager/yqls.py
    lib/db/__init__.py
    lib/db/engine.py
    lib/tasks/__init__.py
    lib/__init__.py
    lib/enums.py
    lib/exceptions.py
)

RESOURCE_FILES(
    PREFIX maps_adv/geosmb/promoter/
    lib/db/migrations/001_20210107/upgrade.sql
    lib/db/migrations/001_20210107/downgrade.sql
    lib/db/migrations/002_20210121/upgrade.sql
    lib/db/migrations/002_20210121/downgrade.sql
    lib/db/migrations/003_20210127/upgrade.sql
    lib/db/migrations/003_20210127/downgrade.sql
    lib/db/migrations/004_20210127/upgrade.sql
    lib/db/migrations/004_20210127/downgrade.sql
    lib/db/migrations/005_20210204/upgrade.sql
    lib/db/migrations/005_20210204/downgrade.sql
    lib/db/migrations/006_20210319/upgrade.sql
    lib/db/migrations/006_20210319/downgrade.sql
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(bin)
