import argparse

from maps_adv.common.config_loader import ConfigLoader, Option, converters
from maps_adv.common.lasagna import setup_logging
from maps_adv.geosmb.promoter.server.lib import Application

arg_parser = argparse.ArgumentParser("Promoter")
arg_parser.add_argument("--host")
arg_parser.add_argument("--port", type=int)

config = ConfigLoader(
    Option("DATABASE_URL"),
    Option("EVENTS_DIR_YT_IMPORT_TABLE", default=None),
    Option("LEADS_YT_EXPORT_TABLE", default=None),
    Option("WARDEN_TASKS", default=(), converter=converters.Tuple()),
    Option("WARDEN_URL", default=None),
    Option("YQL_TOKEN", default=None),
    Option("YT_CLUSTER", default="hahn"),
    Option("YT_TOKEN", default=None),
    Option("TVM_DAEMON_URL", load_from="DEPLOY_TVM_TOOL_URL"),
    Option("TVM_TOKEN", load_from="TVMTOOL_LOCAL_AUTHTOKEN"),
    Option(
        "TVM_GDPR_WHITELIST",
        default=(),
        converter=converters.Tuple(element_converter=int),
    ),
)


def main():
    setup_logging()
    config.init()

    args = arg_parser.parse_args()

    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
