from aiohttp import web
from smb.common.multiruntime.lib.io import setup_filesystem

from maps_adv.common.lasagna import Lasagna

from . import tasks
from .api import create as create_api
from .data_manager import BaseDataManager, DataManager
from .db import DB

setup_filesystem("maps_adv/geosmb/promoter/")


class Application(Lasagna):
    __slots__ = ("dm",)

    SWIM_ENGINE_CLS = DB

    TASKS = {
        "geosmb_promoter__import_recent_events": tasks.LeadEventsYtImportTask,
        "geosmb_promoter__export_leads": tasks.LeadsYtExportTask,
    }
    TASKS_KWARGS_KEYS = ["dm", "config"]

    dm: BaseDataManager

    async def _setup_layers(self, db: DB) -> web.Application:
        self.dm = DataManager(db)

        api = create_api(dm=self.dm)

        return api
