from aiohttp import web

from ..data_manager import BaseDataManager
from .middlewares import handle_application_errors, handle_validation_errors
from .providers import ApiProvider
from .resources import Resources

__all__ = ["create", "ApiProvider"]


def create(dm: BaseDataManager) -> web.Application:
    api = web.Application(
        middlewares=[handle_validation_errors, handle_application_errors]
    )

    resources = Resources(provider=ApiProvider(dm))

    api.add_routes(
        [
            web.get("/ping", resources.ping),
            web.post("/v1/list_leads/", resources.list_leads),
            web.post("/v1/list_segments/", resources.list_segments),
            web.post("/v1/retrieve_lead/", resources.retrieve_lead),
            web.post("/v1/list_lead_events/", resources.list_lead_events),
            web.post("/v1/list_lead_segments/", resources.list_lead_segments),
            web.post(
                "/internal/v1/search_leads_for_gdpr/", resources.search_leads_for_gdpr
            ),
            web.post(
                "/internal/v1/remove_leads_for_gdpr/", resources.remove_leads_for_gdpr
            ),
        ]
    )

    return api
