from aiohttp.web import Request, Response

from maps_adv.common.lasagna import tvm_auth

from .providers import ApiProvider


class Resources:
    __slots__ = ("_provider",)

    _provider: ApiProvider

    def __init__(self, provider: ApiProvider):
        self._provider = provider

    async def ping(self, _: Request) -> Response:
        return Response(status=204)

    async def list_leads(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.list_leads(data=body)

        return Response(status=200, body=result)

    async def retrieve_lead(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.retrieve_lead(data=body)

        return Response(status=200, body=result)

    async def list_segments(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.list_segments(data=body)

        return Response(status=200, body=result)

    async def list_lead_events(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.list_lead_events(data=body)

        return Response(status=200, body=result)

    async def list_lead_segments(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.list_lead_segments(data=body)

        return Response(status=200, body=result)

    @tvm_auth.only("TVM_GDPR_WHITELIST")
    async def search_leads_for_gdpr(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.search_leads_for_gdpr(data=body)

        return Response(status=200, body=result)

    @tvm_auth.only("TVM_GDPR_WHITELIST")
    async def remove_leads_for_gdpr(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.remove_leads_for_gdpr(data=body)

        return Response(status=200, body=result)
