list_leads = """
    WITH biz_leads AS (
        SELECT
            leads.id AS lead_id,
            leads.biz_id,
            leads.name,
            leads.source,
            leads.created_at,
            events_stat_precalced.total_clicks_on_phone as clicks_on_phone,
            events_stat_precalced.total_site_opens as site_opens,
            events_stat_precalced.total_make_routes as make_routes,
            events_stat_precalced.last_review_rating as review_rating,
            events_stat_precalced.total_view_working_hours as view_working_hours,
            events_stat_precalced.total_view_entrances as view_entrances,
            events_stat_precalced.total_showcase_product_click as showcase_product_click,
            events_stat_precalced.total_promo_to_site as promo_to_site,
            events_stat_precalced.total_location_sharing as location_sharing,
            events_stat_precalced.total_geoproduct_button_click as geoproduct_button_click,
            events_stat_precalced.total_favourite_click as favourite_click,
            events_stat_precalced.total_cta_button_click as cta_button_click,
            events_stat_precalced.total_booking_section_interaction as booking_section_interaction,
            events_stat_precalced.last_activity_timestamp,
            array_remove(
                ARRAY[
                    CASE WHEN (
                        last_activity_timestamp >= NOW() - '90 days'::interval
                        AND (last_3_events_timestamp IS NULL
                                 OR last_3_events_timestamp < NOW() - '90 days'::interval
                            )
                        )
                        THEN 'PROSPECTIVE'
                    END,
                    CASE WHEN (
                           last_3_events_timestamp >= NOW() - '90 days'::interval)
                        THEN 'ACTIVE'
                    END,
                    CASE WHEN (last_activity_timestamp < NOW() - '90 days'::interval)
                        THEN 'LOST'
                    END,
                    CASE WHEN (last_review_rating >= '4') THEN 'LOYAL' END,
                    CASE WHEN (last_review_rating < '4') THEN 'DISLOYAL' END
                ], NULL
            ) AS segments
        FROM leads
        JOIN events_stat_precalced ON leads.id = events_stat_precalced.lead_id
        WHERE leads.biz_id = $1
    ),
    leads_filtered AS (
        SELECT *
        FROM biz_leads
        WHERE ($4::text IS NULL OR $4 = ANY(segments))
    ),
    leads_by_limit AS (
        SELECT *
        FROM leads_filtered
        ORDER BY {order_by_expression}, created_at DESC
        LIMIT $2 OFFSET $3        
    )
    SELECT
        leads_by_limit.*,
        tc.total_count
    FROM leads_by_limit
    RIGHT JOIN (SELECT count(*) as total_count FROM leads_filtered) tc ON true
    ORDER BY leads_by_limit.{order_by_expression}, leads_by_limit.created_at DESC
"""  # noqa

list_leads_for_scenarist = """
    SELECT
        leads.id as lead_id,
        leads.biz_id,
        leads.passport_uid,
        leads.yandex_uid,
        leads.device_id,
        leads.name,
        array_remove(
            ARRAY[
                CASE
                    WHEN last_activity_timestamp >= NOW() - '90 days'::interval
                        AND (last_3_events_timestamp IS NULL
                            OR last_3_events_timestamp < NOW() - '90 days'::interval
                            )
                    THEN 'PROSPECTIVE'
                END,
                CASE
                    WHEN last_3_events_timestamp >= NOW() - '90 days'::interval
                    THEN 'ACTIVE'
                END,
                CASE
                    WHEN last_activity_timestamp < NOW() - '90 days'::interval
                    THEN 'LOST'
                END,
                CASE WHEN last_review_rating >= '4' THEN 'LOYAL' END,
                CASE WHEN last_review_rating < '4' THEN 'DISLOYAL' END
            ],
            NULL
        ) AS segments
    FROM leads
    LEFT JOIN events_stat_precalced
        ON leads.id = events_stat_precalced.lead_id

"""

retrieve_lead = """
SELECT
    leads.id AS lead_id,
    leads.biz_id,
    leads.name,
    leads.source,
    leads.created_at,
    events_stat_precalced.total_clicks_on_phone as clicks_on_phone,
    events_stat_precalced.total_site_opens as site_opens,
    events_stat_precalced.total_make_routes as make_routes,
    events_stat_precalced.last_review_rating as review_rating,
    events_stat_precalced.total_view_working_hours as view_working_hours,
    events_stat_precalced.total_view_entrances as view_entrances,
    events_stat_precalced.total_showcase_product_click as showcase_product_click,
    events_stat_precalced.total_promo_to_site as promo_to_site,
    events_stat_precalced.total_location_sharing as location_sharing,
    events_stat_precalced.total_geoproduct_button_click as geoproduct_button_click,
    events_stat_precalced.total_favourite_click as favourite_click,
    events_stat_precalced.total_cta_button_click as cta_button_click,
    events_stat_precalced.total_booking_section_interaction as booking_section_interaction,
    events_stat_precalced.last_activity_timestamp,
    array_remove(
        ARRAY[
            CASE WHEN (
                last_activity_timestamp >= NOW() - '90 days'::interval
                AND (last_3_events_timestamp IS NULL
                         OR last_3_events_timestamp < NOW() - '90 days'::interval
                    )
                )
                THEN 'PROSPECTIVE'
            END,
            CASE WHEN (
                   last_3_events_timestamp >= NOW() - '90 days'::interval)
                THEN 'ACTIVE'
            END,
            CASE WHEN (last_activity_timestamp < NOW() - '90 days'::interval)
                THEN 'LOST'
            END,
            CASE WHEN (last_review_rating >= '4') THEN 'LOYAL' END,
            CASE WHEN (last_review_rating < '4') THEN 'DISLOYAL' END
        ], NULL
    ) AS segments
FROM leads
JOIN events_stat_precalced ON leads.id = events_stat_precalced.lead_id
WHERE leads.biz_id = $1 AND leads.id = $2
"""  # noqa

list_lead_events = """
    WITH filtered_lead_events AS(
        SELECT *
        FROM lead_events
        WHERE biz_id = $1
            AND lead_id = $2
    ),
    events_by_limit AS (
        SELECT
            event_type,
            event_value,
            event_timestamp,
            source,
            created_at
        FROM filtered_lead_events
        ORDER BY event_timestamp DESC, created_at DESC
        LIMIT $3 OFFSET $4
    )
    SELECT
        events_by_limit.event_type,
        events_by_limit.event_value,
        events_by_limit.event_timestamp,
        events_by_limit.source,
        te.total_events
    FROM events_by_limit
    RIGHT JOIN (
        SELECT count(*) as total_events
        FROM filtered_lead_events
    ) te ON true
    ORDER BY
        events_by_limit.event_timestamp DESC,
        events_by_limit.created_at DESC
"""


list_lead_segments = """
    SELECT
        leads.id AS lead_id,
        leads.biz_id,
        array_remove(
            ARRAY[
                CASE WHEN (
                    last_activity_timestamp >= NOW() - '90 days'::interval
                    AND (last_3_events_timestamp IS NULL
                             OR last_3_events_timestamp < NOW() - '90 days'::interval
                        )
                    )
                    THEN 'PROSPECTIVE'
                END,
                CASE WHEN (
                       last_3_events_timestamp >= NOW() - '90 days'::interval)
                    THEN 'ACTIVE'
                END,
                CASE WHEN (last_activity_timestamp < NOW() - '90 days'::interval)
                    THEN 'LOST'
                END,
                CASE WHEN (last_review_rating >= '4') THEN 'LOYAL' END,
                CASE WHEN (last_review_rating < '4') THEN 'DISLOYAL' END
            ], NULL
        ) AS segments
    FROM leads
    JOIN events_stat_precalced ON leads.id = events_stat_precalced.lead_id
    WHERE ($1::bigint IS NULL OR leads.biz_id = $1) AND {leads_filter_str}
    ORDER BY created_at DESC
"""


check_leads_existence_by_passport = """
    SELECT EXISTS(
        SELECT 1
        FROM leads
        WHERE passport_uid = $1
    )
"""

delete_leads_data_by_passport = """
    WITH leads_to_remove AS (
        SELECT id as lead_id
        FROM leads
        WHERE passport_uid = $1
    ),
    removed_precalced_events AS (
        DELETE FROM events_stat_precalced
        USING leads_to_remove
        WHERE events_stat_precalced.lead_id = leads_to_remove.lead_id
    ),
    removed_events AS (
        DELETE FROM lead_events
        USING leads_to_remove
        WHERE lead_events.lead_id = leads_to_remove.lead_id
    ),
    removed_lead_revisions AS (
        DELETE FROM lead_revisions
        USING leads_to_remove
        WHERE lead_revisions.lead_id = leads_to_remove.lead_id
    ),
    deleted_leads AS (
        DELETE FROM leads
        USING leads_to_remove
        WHERE id = leads_to_remove.lead_id
        RETURNING leads.id AS lead_id, leads.biz_id
    )
    SELECT *
    FROM deleted_leads
    ORDER BY lead_id
"""
