-- Rename existing fields to make room for new ones
ALTER TYPE lead_source RENAME TO lead_data_source;

ALTER TABLE leads
    RENAME COLUMN source TO data_source;

ALTER TABLE lead_revisions
    RENAME COLUMN source TO data_source;

ALTER TYPE event_source RENAME TO event_data_source;

ALTER TABLE lead_events
    RENAME COLUMN source TO data_source;

-- Create new fields with new type
CREATE TYPE source AS ENUM (
    'DIRECT',
    'ORGANIC',
    'TOPONYM_ADVERT',
    'YABS',
    'ZEN'
);

ALTER TABLE leads
    ADD COLUMN source source;

ALTER TABLE lead_events
    ADD COLUMN source source;
