from enum import Enum, auto, unique

__all__ = [
    "LeadDataSource",
    "EventDataSource",
    "EventType",
    "OrderDirection",
    "OrderByField",
    "SegmentType",
    "Source",
]


@unique
class LeadDataSource(Enum):
    YT = auto()


@unique
class EventDataSource(Enum):
    SPRAV = auto()
    MOBILE = auto()
    DESKTOP_MAPS = auto()


@unique
class EventType(Enum):
    REVIEW = auto()
    CLICK_ON_PHONE = auto()
    OPEN_SITE = auto()
    MAKE_ROUTE = auto()
    VIEW_WORKING_HOURS = auto()
    VIEW_ENTRANCES = auto()
    CTA_BUTTON_CLICK = auto()
    FAVOURITE_CLICK = auto()
    LOCATION_SHARING = auto()
    BOOKING_SECTION_INTERACTION = auto()
    SHOWCASE_PRODUCT_CLICK = auto()
    PROMO_TO_SITE = auto()
    GEOPRODUCT_BUTTON_CLICK = auto()


@unique
class Source(Enum):
    EXTERNAL_ADVERT = auto()
    STRAIGHT = auto()
    DISCOVERY_ADVERT = auto()
    DISCOVERY_NO_ADVERT = auto()


@unique
class OrderByField(Enum):
    NAME = "name"
    MAKE_ROUTES = "make_routes"
    REVIEW_RATING = "review_rating"
    CLICKS_ON_PHONE = "clicks_on_phone"
    SITE_OPENS = "site_opens"
    VIEW_WORKING_HOURS = "view_working_hours"
    VIEW_ENTRANCES = "view_entrances"
    CTA_BUTTON_CLICK = "cta_button_click"
    FAVOURITE_CLICK = "favourite_click"
    LOCATION_SHARING = "location_sharing"
    BOOKING_SECTION_INTERACTION = "booking_section_interaction"
    SHOWCASE_PRODUCT_CLICK = "showcase_product_click"
    PROMO_TO_SITE = "promo_to_site"
    GEOPRODUCT_BUTTON_CLICK = "geoproduct_button_click"
    LAST_ACTIVITY_TIMESTAMP = "last_activity_timestamp"


@unique
class OrderDirection(Enum):
    ASC = auto()
    DESC = auto()


@unique
class SegmentType(Enum):
    PROSPECTIVE = auto()
    ACTIVE = auto()
    LOST = auto()
    LOYAL = auto()
    DISLOYAL = auto()
