PY3TEST()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/pytest-asyncio
    contrib/python/pytest-mock
    contrib/python/pytest-freezegun

    smb/common/pgswim/pytest
    smb/common/testing_utils

    maps_adv/common/lasagna/pytest
    maps_adv/common/shared_mock/pytest
    maps_adv/geosmb/promoter/server
)

SRCDIR(maps_adv/geosmb/promoter/server)

PY_SRCS(
    __init__.py
    api/__init__.py
    api/list_leads/__init__.py
    api/list_segments/__init__.py
    api/list_segments/utils.py
    data_manager/__init__.py
    data_manager/import_events/__init__.py
    data_manager/list_leads/__init__.py
    data_manager/list_segments/__init__.py
    tasks/__init__.py
    conftest.py
    factory.py
)

TEST_SRCS(
    api/list_leads/test_filter_by_segment.py
    api/list_leads/test_list_leads.py
    api/list_leads/test_list_pagination.py
    api/list_leads/test_segmentation.py
    api/list_leads/test_sorting.py
    api/list_segments/test_active_segment.py
    api/list_segments/test_disloyal_segment.py
    api/list_segments/test_list_segments.py
    api/list_segments/test_lost_segment.py
    api/list_segments/test_loyal_segment.py
    api/list_segments/test_prospective_segment.py
    api/test_list_lead_segments.py
    api/test_list_lead_events.py
    api/test_ping.py
    api/test_remove_leads_for_gdpr.py
    api/test_retrieve_lead.py
    api/test_search_leads_for_gdpr.py
    data_manager/import_events/test_update_leads.py
    data_manager/import_events/test_merge_leads.py
    data_manager/import_events/test_create_leads.py
    data_manager/import_events/test_precalced_stats.py
    data_manager/import_events/test_match_leads_with_events.py
    data_manager/list_leads/test_filter_by_segment.py
    data_manager/list_leads/test_list_leads.py
    data_manager/list_leads/test_list_pagination.py
    data_manager/list_leads/test_segmentation.py
    data_manager/list_leads/test_sorting.py
    data_manager/list_segments/test_active_segment.py
    data_manager/list_segments/test_disloyal_segment.py
    data_manager/list_segments/test_list_segments.py
    data_manager/list_segments/test_lost_segment.py
    data_manager/list_segments/test_loyal_segment.py
    data_manager/list_segments/test_prospective_segment.py
    data_manager/test_check_leads_existance_by_passport.py
    data_manager/test_delete_leads_data_by_passport.py
    data_manager/test_list_lead_segments.py
    data_manager/test_iter_leads_for_export.py
    data_manager/test_list_lead_events.py
    data_manager/test_retrieve_lead.py
    tasks/test_leads_yt_export.py
    tasks/test_tasks_warden_integration.py
)

ENV(DATABASE_URL_FOR_TESTS=postgresql://promoter:promoter@localhost:5433/promoter?master_as_replica=true)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
)

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all
    dns:dns64
)

END()
