PY3_LIBRARY()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/email-validator
    contrib/python/marshmallow/py2
    contrib/python/marshmallow-enum/py2

    yql/library/python

    smb/common/multiruntime
    smb/common/pgswim

    smb/common/aiotvm
    maps_adv/common/config_loader
    maps_adv/common/email_sender
    maps_adv/common/helpers
    smb/common/http_client
    maps_adv/common/lasagna
    maps_adv/common/protomallow
    maps_adv/common/yt_utils
    maps_adv/geosmb/clients/facade
    maps_adv/geosmb/scenarist/proto
)

PY_SRCS(
    lib/__init__.py
    lib/api/__init__.py
    lib/api/middlewares.py
    lib/api/providers.py
    lib/api/resources.py
    lib/clients/__init__.py
    lib/clients/fake_email_sender.py
    lib/data_manager/__init__.py
    lib/data_manager/scenarios.py
    lib/data_manager/sqls.py
    lib/db/__init__.py
    lib/db/engine.py
    lib/domain.py
    lib/enums.py
    lib/exceptions.py
    lib/tasks.py
)

RESOURCE_FILES(
    PREFIX maps_adv/geosmb/scenarist/server/
    lib/db/migrations/001_20201221/upgrade.sql
    lib/db/migrations/001_20201221/downgrade.sql
    lib/db/migrations/002_20201222/upgrade.sql
    lib/db/migrations/002_20201222/downgrade.sql

    DEST templates/disloyal_advert_less_month.tpl.html lib/templates/disloyal_advert_less_month.tpl.html
    DEST templates/disloyal_advert_more_month.tpl.html lib/templates/disloyal_advert_more_month.tpl.html
    DEST templates/disloyal_no_advert_less_month.tpl.html lib/templates/disloyal_no_advert_less_month.tpl.html
    DEST templates/disloyal_no_advert_more_month.tpl.html lib/templates/disloyal_no_advert_more_month.tpl.html
    DEST templates/disloyal_several_less_month.tpl.html lib/templates/disloyal_several_less_month.tpl.html
    DEST templates/disloyal_several_more_month.tpl.html lib/templates/disloyal_several_more_month.tpl.html
    DEST templates/lost_advert.tpl.html lib/templates/lost_advert.tpl.html
    DEST templates/lost_no_advert.tpl.html lib/templates/lost_no_advert.tpl.html
    DEST templates/lost_several.tpl.html lib/templates/lost_several.tpl.html
    DEST templates/loyal_advert_less_month.tpl.html lib/templates/loyal_advert_less_month.tpl.html
    DEST templates/loyal_advert_more_month.tpl.html lib/templates/loyal_advert_more_month.tpl.html
    DEST templates/loyal_no_advert_less_month.tpl.html lib/templates/loyal_no_advert_less_month.tpl.html
    DEST templates/loyal_no_advert_more_month.tpl.html lib/templates/loyal_no_advert_more_month.tpl.html
    DEST templates/loyal_several_less_month.tpl.html lib/templates/loyal_several_less_month.tpl.html
    DEST templates/loyal_several_more_month.tpl.html lib/templates/loyal_several_more_month.tpl.html
    DEST templates/potential_advert.tpl.html lib/templates/potential_advert.tpl.html
    DEST templates/potential_no_advert.tpl.html lib/templates/potential_no_advert.tpl.html
    DEST templates/potential_several.tpl.html lib/templates/potential_several.tpl.html
    DEST templates/template_for_testing.tpl.html lib/templates/template_for_testing.tpl.html
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(bin)
