import argparse

from maps_adv.common.config_loader import ConfigLoader, Option, converters
from maps_adv.common.lasagna import setup_logging
from maps_adv.geosmb.scenarist.server.lib import Application

config = ConfigLoader(
    Option("DATABASE_URL"),
    Option("FACADE_URL"),
    Option("SUBSCRIPTIONS_YT_EXPORT_TABLE", default=None),
    Option("TVM_DAEMON_URL", load_from="DEPLOY_TVM_TOOL_URL"),
    Option("TVM_TOKEN", load_from="TVMTOOL_LOCAL_AUTHTOKEN"),
    Option("WARDEN_TASKS", default=(), converter=converters.Tuple()),
    Option("WARDEN_URL", default=None),
    Option("YT_CLUSTER", default="hahn"),
    Option("YT_TOKEN", default=None),
    Option("EMAIL_CLIENT_API_URL", default=None),
    Option("EMAIL_CLIENT_ACCOUNT_SLUG", default=None),
    Option("EMAIL_CLIENT_ACCOUNT_TOKEN", default=None),
    Option("EMAIL_CLIENT_CAMPAIGN_TITLE", default="Рассылка из сценариста"),
    Option("EMAIL_CLIENT_FROM_NAME", default=None),
    Option("EMAIL_CLIENT_FROM_EMAIL", default=None),
    Option("EMAIL_CLIENT_UNSUBSCRIBE_LIST_SLUG", default=None),
    Option(
        "EMAIL_CLIENT_ALLOWED_STAT_DOMAINS", converter=converters.Tuple(), default=None
    ),
    Option("SUBSCRIPTIONS_YT_EXPORT_TABLE", default=None),
    Option("SUBSCRIPTIONS_VERSIONS_YT_EXPORT_TABLE", default=None),
    Option("MESSAGES_YT_IMPORT_DIR", default=None),
    Option("CERTIFICATE_MAILING_STATS_YT_IMPORT_DIR", default=None),
    Option("SEND_REAL_EMAILS", converter=converters.Bool(), default=False),
)

arg_parser = argparse.ArgumentParser("Scenarist")
arg_parser.add_argument("--host")
arg_parser.add_argument("--port", type=int)


def main():
    setup_logging()
    config.init()

    args = arg_parser.parse_args()

    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
