from aiohttp import web

from ..domain import Domain
from .middlewares import handle_data_manager_errors, handle_validation_errors
from .providers import ApiProvider
from .resources import Resources

__all__ = ["create"]


def create(domain: Domain) -> web.Application:
    api = web.Application(
        middlewares=[handle_validation_errors, handle_data_manager_errors]
    )

    resources = Resources(ApiProvider(domain))

    api.add_routes([web.get("/ping", resources.ping)])
    api.add_routes(
        [
            web.post("/v1/list_scenarios/", resources.list_scenarios),
            web.post("/v1/create_subscription/", resources.create_subscription),
            web.post("/v1/retrieve_subscription/", resources.retrieve_subscription),
            web.post(
                "/v1/update_subscription_status/", resources.update_subscription_status
            ),
            web.post(
                "/v1/replace_subscription_coupon/",
                resources.replace_subscription_coupon,
            ),
        ]
    )

    return api
