from aiohttp.web import Request, Response

from .providers import ApiProvider


class Resources:
    __slots__ = ("_provider",)

    _provider: ApiProvider

    def __init__(self, provider: ApiProvider):
        self._provider = provider

    async def ping(self, _: Request) -> Response:
        return Response(status=204)

    async def list_scenarios(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.list_scenarios(data=body)

        return Response(status=200, body=result)

    async def create_subscription(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.create_subscription(data=body)

        return Response(status=201, body=result)

    async def retrieve_subscription(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.retrieve_subscription(data=body)

        return Response(status=200, body=result)

    async def update_subscription_status(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.update_subscription_status(data=body)

        return Response(status=200, body=result)

    async def replace_subscription_coupon(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.replace_subscription_coupon(data=body)

        return Response(status=200, body=result)
