from enum import Enum, auto, unique


@unique
class ScenarioName(Enum):
    DISCOUNT_FOR_LOST = "discount_for_lost"
    ENGAGE_PROSPECTIVE = "engage_prospective"
    THANK_THE_LOYAL = "thank_the_loyal"
    DISCOUNT_FOR_DISLOYAL = "discount_for_disloyal"


@unique
class SegmentType(Enum):
    PROSPECTIVE = "prospective"
    ACTIVE = "active"
    LOST = "lost"
    LOYAL = "loyal"
    DISLOYAL = "disloyal"
    REGULAR = "regular"
    NO_ORDERS = "no_orders"
    UNPROCESSED_ORDERS = "unprocessed_orders"

    ALL = auto()


@unique
class SubscriptionStatus(Enum):
    ACTIVE = "active"
    PAUSED = "paused"
    COMPLETED = "completed"


class MessageType(Enum):
    EMAIL = "email"
    PUSH = "push"
    SMS = "sms"
