from collections.abc import Mapping

from maps_adv.common.yt_utils import BaseYtExportTask, BaseYtImportDirTask
from maps_adv.geosmb.scenarist.server.lib.data_manager import BaseDataManager
from maps_adv.geosmb.scenarist.server.lib.domain import Domain

__all__ = [
    "SubscriptionsYtExportTask",
    "SubscriptionsVersionsYtExportTask",
    "MessagesYtImportTask",
    "CertificateMailingStatYtImportTask",
    "process_unsent_emails",
]


class SubscriptionsYtExportTask(BaseYtExportTask):
    TABLE_SCHEMA = [
        dict(name="subscription_id", type="uint64", required=True),
        dict(name="scenario_code", type="string", required=True),
        dict(name="segments", type_v3={"type_name": "list", "item": "string"}),
        dict(name="biz_id", type="uint64", required=True),
        dict(name="coupon_id", type="uint64", required=True),
    ]

    ITER_SIZE: int = 1000
    CHUNKED_ITERATOR_METHOD_NAME: str = "iter_subscriptions_for_export"
    TIMEOUT: int = 60

    def __init__(self, *args, config: Mapping, domain: Domain, **kwargs):
        super().__init__(
            cluster=config["YT_CLUSTER"],
            token=config["YT_TOKEN"],
            table=config["SUBSCRIPTIONS_YT_EXPORT_TABLE"],
            data_producer=domain,
        )


class SubscriptionsVersionsYtExportTask(BaseYtExportTask):
    TABLE_SCHEMA = [
        dict(name="version_id", type="uint64", required=True),
        dict(name="subscription_id", type="uint64", required=True),
        dict(name="biz_id", type="uint64", required=True),
        dict(name="scenario_code", type="string", required=True),
        dict(name="coupon_id", type="uint64", required=True),
        dict(name="status", type="string", required=True),
        dict(name="created_at", type="timestamp", required=True),
    ]

    ITER_SIZE: int = 10000
    CHUNKED_ITERATOR_METHOD_NAME: str = "iter_subscriptions_versions_for_export"
    TIMEOUT: int = 60

    def __init__(self, *args, config: Mapping, dm: BaseDataManager, **kwargs):
        super().__init__(
            cluster=config["YT_CLUSTER"],
            token=config["YT_TOKEN"],
            table=config["SUBSCRIPTIONS_VERSIONS_YT_EXPORT_TABLE"],
            data_producer=dm,
        )


class MessagesYtImportTask(BaseYtImportDirTask):
    ITER_SIZE: int = 1000
    CHUNKED_WRITER_METHOD_NAME = "copy_messages_from_generator"
    PROCESSED_ATTR = "_geosmb_processed"

    TIMEOUT = 30

    def __init__(self, *args, config: Mapping, dm: BaseDataManager, **kwargs):
        super().__init__(
            cluster=config["YT_CLUSTER"],
            yt_token=config["YT_TOKEN"],
            yt_dir=config["MESSAGES_YT_IMPORT_DIR"],
            data_consumer=dm,
        )


class CertificateMailingStatYtImportTask(BaseYtImportDirTask):
    ITER_SIZE: int = 1000
    CHUNKED_WRITER_METHOD_NAME = "import_certificate_mailing_stats"
    PROCESSED_ATTR = "_geosmb_processed"

    TIMEOUT = 60

    def __init__(self, *args, config: Mapping, dm: BaseDataManager, **kwargs):
        super().__init__(
            cluster=config["YT_CLUSTER"],
            yt_token=config["YT_TOKEN"],
            yt_dir=config["CERTIFICATE_MAILING_STATS_YT_IMPORT_DIR"],
            data_consumer=dm,
        )


async def process_unsent_emails(*args, domain: Domain, **kwargs):
    await domain.process_unsent_emails()
