PY3TEST()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/aresponses
    contrib/python/pytest-asyncio
    contrib/python/pytest-freezegun
    contrib/python/pytest-mock

    smb/common/pgswim/pytest
    smb/common/testing_utils

    maps_adv/common/lasagna/pytest
    maps_adv/common/shared_mock/pytest
    maps_adv/geosmb/clients/facade/pytest
    maps_adv/geosmb/scenarist/server
)

PY_SRCS(
    __init__.py
    api/__init__.py
    clients/__init__.py
    conftest.py
    data_manager/__init__.py
    domain/__init__.py
    factory.py
    tasks/__init__.py
    utils.py
)

TEST_SRCS(
    api/test_create_subscription.py
    api/test_list_scenarios.py
    api/test_ping.py
    api/test_replace_subscription_coupon.py
    api/test_retrieve_subscription.py
    api/test_update_subscription_status.py
    clients/test_fake_email_sender.py
    data_manager/test_copy_messages_from_generator.py
    data_manager/test_create_subscription.py
    data_manager/test_find_scenario_by_name.py
    data_manager/test_import_certificate_sent_stats.py
    data_manager/test_iter_subscriptions_for_export.py
    data_manager/test_iter_subscriptions_versions_for_export.py
    data_manager/test_list_scenarios.py
    data_manager/test_list_unprocessed_email_messages.py
    data_manager/test_mark_messages_processed.py
    data_manager/test_replace_subscription_coupon.py
    data_manager/test_retrieve_subscription.py
    data_manager/test_retrieve_subscription_current_state.py
    data_manager/test_update_subscription_status.py
    data_manager/test_update_subscriptions_statuses.py
    domain/test_create_subscription.py
    domain/test_iter_subscriptions_for_export.py
    domain/test_list_scenarios.py
    domain/test_replace_subscription_coupon.py
    domain/test_retrieve_subscription.py
    domain/test_update_subscription_status.py
    domain/test_process_unsent_emails.py
    tasks/test_certificate_sent_stat_import.py
    tasks/test_subscriptions_yt_export.py
    tasks/test_message_yt_import.py
    tasks/test_subscriptions_versions_yt_export.py
    tasks/test_tasks_warden_integration.py
)

ENV(DATABASE_URL_FOR_TESTS=postgresql://scenarist:scenarist@localhost:5433/scenarist?master_as_replica=true)

INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

CONFTEST_LOAD_POLICY_LOCAL()

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
)

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all
    dns:dns64
)

END()
