import argparse

from maps_adv.common.config_loader import ConfigLoader, Option, converters
from maps_adv.common.lasagna import setup_logging
from maps_adv.geosmb.telegraphist.server.lib import Application

config = ConfigLoader(
    Option("EMAIL_CLIENT_ACCOUNT_SLUG"),
    Option("EMAIL_CLIENT_ACCOUNT_TOKEN"),
    Option("EMAIL_CLIENT_API_URL"),
    Option("LIMIT_RECIPIENTS", converter=converters.Bool(), default=True),
    Option("PURCHASED_CERTIFICATE_EMAIL_TEMPLATE_CODE"),
    Option("TVM_DAEMON_URL", load_from="DEPLOY_TVM_TOOL_URL"),
    Option("TVM_TOKEN", load_from="TVMTOOL_LOCAL_AUTHTOKEN"),
    Option("YASMS_SENDER", default=None),
    Option("YASMS_URL", default=None),
    Option("DOORMAN_TVM_ID", default="doorman"),
    Option("DOORMAN_URL", default=None),
    Option("BVM_URL", default=None),
    Option("GEOSEARCH_URL", default=None),
    Option("GEOSEARCH_TVM_ID", default="geosearch"),
    Option("TUNER_URL", default=None),
    Option("NOTIFY_ME_URL", default=None),
    Option("YAV_SECRET_ID", default=None),
    Option("YAV_TOKEN", default=None),
    Option(
        "TVM_WHITELIST", default=None, converter=converters.Tuple(element_converter=int)
    ),
    Option("EMAIL_TEMPLATE_CODE_CART_ORDER_CREATED"),
    Option("EMAIL_TEMPLATE_CODE_ORDER_CREATED"),
    Option("EMAIL_TEMPLATE_CODE_ORDER_REMINDER"),
    Option("EMAIL_TEMPLATE_CODE_ORDER_CHANGED"),
    Option("EMAIL_TEMPLATE_CODE_ORDER_CANCELLED"),
    Option("EMAIL_TEMPLATE_CODE_ORDER_CANCELLED_FOR_BUSINESS"),
    Option("EMAIL_TEMPLATE_CODE_ORDER_CREATED_FOR_BUSINESS"),
    Option("EMAIL_TEMPLATE_CODE_ORDER_CHANGED_FOR_BUSINESS"),
    Option("EMAIL_TEMPLATE_CODE_CERTIFICATE_EXPIRING"),
    Option("EMAIL_TEMPLATE_CODE_CERTIFICATE_EXPIRED"),
    Option("EMAIL_TEMPLATE_CODE_CERTIFICATE_CREATED"),
    Option("EMAIL_TEMPLATE_CODE_CERTIFICATE_CONNECT_PAYMENT"),
    Option("EMAIL_TEMPLATE_CODE_CERTIFICATE_REJECTED"),
    Option("EMAIL_TEMPLATE_CODE_FIRST_CERTIFICATE_APPROVED"),
    Option("EMAIL_TEMPLATE_CODE_SUBSEQUENT_CERTIFICATE_APPROVED"),
    Option("EMAIL_TEMPLATE_CODE_CERTIFICATE_PURCHASED"),
    Option("EMAIL_TEMPLATE_CODE_REQUEST_CREATED_FOR_BUSINESS"),
    Option("SUP_OAUTH_TOKEN"),
    Option("SUP_URL"),
    Option("SUP_PROJECT"),
    Option("SUP_THROTTLE_POLICY_NAME"),
)

arg_parser = argparse.ArgumentParser("Telegraphist")
arg_parser.add_argument("--host")
arg_parser.add_argument("--port", type=int)


def main():
    setup_logging()
    config.init()

    args = arg_parser.parse_args()

    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
