from aiohttp import web

from maps_adv.geosmb.telegraphist.server.lib.domain import Domain

from . import middlewares
from .resources import Resources

__all__ = ["create"]


def create(domain: Domain) -> web.Application:
    api = web.Application(
        middlewares=[
            middlewares.handle_validation_errors,
            middlewares.handle_application_errors,
        ]
    )

    resources = Resources(domain)

    api.add_routes(
        [
            web.get("/ping", resources.ping),
            web.post("/api/v1/send-notification/", resources.send_notification_v1),
            web.post("/api/v2/send-notification/", resources.send_notification_v2),
            web.post(
                "/api/v2/send-notification-for-business/",
                resources.send_notification_for_business,
            ),
            web.post(
                "/api/v3/send-notification/",
                resources.send_notification_v3,
            ),
        ]
    )

    return api
