from marshmallow import fields, validate

from maps_adv.common.protomallow import PbDateTimeField, ProtobufSchema
from maps_adv.geosmb.telegraphist.proto import notifications_v1_pb2


class PurchasedCertificateNotificationDetailsSchema(ProtobufSchema):
    class Meta:
        pb_message_class = notifications_v1_pb2.PurchasedCertificateNotificationDetails

    org_name = fields.String(required=True, validate=[validate.Length(min=1)])
    certificate_code = fields.String(required=True, validate=[validate.Length(min=1)])
    active_from = PbDateTimeField(required=True)
    active_to = PbDateTimeField(required=True)
    link_to_org = fields.String(required=True, validate=[validate.Length(min=1)])


class EmailNotificationSchema(ProtobufSchema):
    class Meta:
        pb_message_class = notifications_v1_pb2.EmailNotification

    recipient = fields.String(required=True, validate=[validate.Email()])
    purchased_certificate_details = fields.Nested(
        PurchasedCertificateNotificationDetailsSchema
    )
