import enum

__all__ = ["NotificationType", "Transport"]


class Transport(enum.Enum):
    SMS = "SMS"
    EMAIL = "EMAIL"
    PUSH = "PUSH"
    TELEGRAM = "TELEGRAM"


class NotificationType(enum.Enum):
    CART_ORDER_CREATED = "cart_order_created"
    ORDER_CREATED = "order_created"
    ORDER_REMINDER = "order_reminder"
    ORDER_CHANGED = "order_changed"
    ORDER_CANCELLED = "order_cancelled"
    ORDER_CREATED_FOR_BUSINESS = "order_created_for_business"
    ORDER_CHANGED_FOR_BUSINESS = "order_changed_for_business"
    ORDER_CANCELLED_FOR_BUSINESS = "order_cancelled_for_business"
    CERTIFICATE_EXPIRING = "certificate_expiring"
    CERTIFICATE_EXPIRED = "certificate_expired"
    CERTIFICATE_CONNECT_PAYMENT = "certificate_connect_payment"
    CERTIFICATE_REJECTED = "certificate_rejected"
    FIRST_CERTIFICATE_APPROVED = "first_certificate_approved"
    SUBSEQUENT_CERTIFICATE_APPROVED = "subsequent_certificate_approved"
    CERTIFICATE_CREATED = "certificate_created"
    CERTIFICATE_PURCHASED = "certificate_purchased"
    REQUEST_CREATED_FOR_BUSINESS = "request_created_for_business"
