from typing import List

from maps_adv.geosmb.telegraphist.server.lib.enums import NotificationType, Transport

__all__ = [
    "TelegraphistException",
    "RecipientDenied",
    "NoOrgsForBizId",
    "NoOrginfo",
    "UnsupportedTransport",
    "UnsupportedNotificationType",
    "TransportException",
    "NoAddress",
    "AddressNotAllowed",
    "SendFailed",
    "NoOrderLink",
    "NotificationDisabledInSettings",
]


class TelegraphistException(Exception):
    pass


class RecipientDenied(TelegraphistException):
    pass


class NoOrgsForBizId(TelegraphistException):
    pass


class NoOrginfo(TelegraphistException):
    pass


class UnsupportedTransport(Exception):
    def __init__(
        self, notification_type: NotificationType, transports: List[Transport]
    ):
        self.notification_type = notification_type
        self.transports = transports


class UnsupportedNotificationType(Exception):
    def __init__(self, notification_type: NotificationType):
        self.notification_type = notification_type


class TransportException(Exception):
    text = None


class NoAddress(TransportException):
    text = "No address to send to"


class AddressNotAllowed(TransportException):
    text = "Address not allowed"


class SendFailed(TransportException):
    text = "Send failed"


class NoOrderLink(TransportException):
    text = "No link to order details"


class NotificationDisabledInSettings(TransportException):
    text = "Notification type is disabled in Settings"
