PY3TEST()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/aresponses
    contrib/python/pytest-asyncio
    contrib/python/pytest-mock
    contrib/python/pytest-freezegun

    smb/common/testing_utils

    smb/common/aiotvm/pytest
    maps_adv/common/helpers
    maps_adv/common/lasagna/pytest
    maps_adv/geosmb/clients/bvm/pytest
    maps_adv/geosmb/clients/geosearch/pytest
    maps_adv/geosmb/doorman/client/pytest

    maps_adv/geosmb/telegraphist/server
)

SRCDIR(maps_adv/geosmb/telegraphist/server)

PY_SRCS(
    __init__.py
    api/__init__.py
    api/v1/__init__.py
    api/v2/__init__.py
    api/v2/send_notification_for_business/__init__.py
    api/v3/__init__.py
    conftest.py
    domain/__init__.py
    domain/v2/__init__.py
    domain/v2/send_notification_for_business/__init__.py
    domain/v3/__init__.py
    helpers.py
    notification_router/__init__.py
    notification_router/conftest.py
    notification_router/send_client_notification/__init__.py
    notification_router/send_business_notification/__init__.py
    notification_router_v3/__init__.py
    notification_router_v3/conftest.py
    notification_router_v3/send_notification/__init__.py
    templates/__init__.py
)

TEST_SRCS(
    api/test_ping.py
    api/test_purchased_certificate_notification.py
    api/v2/test_send_notification.py
    api/v2/send_notification_for_business/test_send_notification_for_business.py
    api/v2/send_notification_for_business/test_send_notifications_about_certificates.py
    api/v2/send_notification_for_business/test_send_notifications_about_orders.py
    api/v2/send_notification_for_business/test_send_notifications_about_requests.py
    api/v3/test_send_notification.py
    domain/test_send_notification_v1.py
    domain/v2/test_send_notification.py
    domain/v2/send_notification_for_business/test_send_notification_for_business.py
    domain/v2/send_notification_for_business/test_send_notification_about_orders.py
    domain/v2/send_notification_for_business/test_send_notification_about_certificates.py
    domain/v2/send_notification_for_business/test_send_notification_about_requests.py
    domain/v3/test_send_notification.py
    notification_router/test_push_templates.py
    notification_router/test_sms_templates.py
    notification_router/send_business_notification/test_common.py
    notification_router/send_business_notification/test_transport_email.py
    notification_router/send_business_notification/test_transport_sms.py
    notification_router/send_client_notification/test_common.py
    notification_router/send_client_notification/test_transport_email.py
    notification_router/send_client_notification/test_transport_push.py
    notification_router/send_client_notification/test_transport_sms.py
    notification_router_v3/send_notification/test_common.py
    notification_router_v3/send_notification/test_transport_email.py
    notification_router_v3/send_notification/test_transport_sms.py
    notification_router_v3/send_notification/test_transport_telegram.py
    templates/test_context_processors.py
    templates/test_filters.py
    test_ru_format_date.py
)

CONFTEST_LOAD_POLICY_LOCAL()

END()
