PY3_LIBRARY()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/Babel
    contrib/python/Jinja2
    contrib/python/aiohttp
    contrib/python/emoji

    smb/common/multiruntime
    maps_adv/common/aiosup
    maps_adv/common/aioyav
    maps_adv/common/config_loader
    maps_adv/common/email_sender
    maps_adv/common/lasagna
    maps_adv/common/yasms
    maps_adv/geosmb/clients/bvm
    maps_adv/geosmb/clients/geosearch
    maps_adv/geosmb/clients/notify_me
    maps_adv/geosmb/doorman/client
    maps_adv/geosmb/telegraphist/proto
    maps_adv/geosmb/tuner/client
)

PY_SRCS(
    lib/__init__.py
    lib/api/__init__.py
    lib/api/middlewares.py
    lib/api/resources.py
    lib/api/schemas/__init__.py
    lib/api/schemas/v1.py
    lib/api/schemas/v2.py
    lib/api/schemas/v3.py
    lib/domain.py
    lib/enums.py
    lib/exceptions.py
    lib/notification_router.py
    lib/notification_router_v3.py
    lib/templates/__init__.py
    lib/templates/push/__init__.py
)

RESOURCE_FILES(
    PREFIX maps_adv/geosmb/telegraphist/server/
    lib/templates/order_cancelled_sms.jinja
    lib/templates/order_changed_sms.jinja
    lib/templates/order_created_sms.jinja
    lib/templates/order_reminder_sms.jinja
    lib/templates/request_created_for_business_sms.jinja
    lib/templates/request_created_for_business_telegram.jinja
    lib/templates/push/order_cancelled_push.jinja
    lib/templates/push/order_created_push.jinja
    lib/templates/push/order_changed_push.jinja
    lib/templates/push/order_reminder_push.jinja
)


END()

RECURSE_FOR_TESTS(tests)

RECURSE(bin)
