import argparse

from maps_adv.common.config_loader import ConfigLoader, Option, converters
from maps_adv.common.lasagna import setup_logging
from maps_adv.geosmb.tuner.server.lib import Application

config = ConfigLoader(
    Option("DATABASE_URL"),
    Option("TVM_DAEMON_URL", load_from="DEPLOY_TVM_TOOL_URL"),
    Option("TVM_TOKEN", load_from="TVMTOOL_LOCAL_AUTHTOKEN"),
    Option(
        "TVM_WHITELIST", default=None, converter=converters.Tuple(element_converter=int)
    ),
)

arg_parser = argparse.ArgumentParser("Tuner")
arg_parser.add_argument("--host")
arg_parser.add_argument("--port", type=int)


def main():
    setup_logging()
    config.init()

    args = arg_parser.parse_args()

    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
