from aiohttp import web

from smb.common.multiruntime.lib.io import setup_filesystem

from maps_adv.common.lasagna import Lasagna

from . import api
from .data_manager import DataManager
from .db import DB
from .domain import Domain

setup_filesystem("maps_adv/geosmb/tuner/server/")


class Application(Lasagna):
    SWIM_ENGINE_CLS = DB

    async def _setup_layers(self, db: DB) -> web.Application:
        self.dm = DataManager(db)

        self.domain = Domain(dm=self.dm)

        _api = api.create(self.domain, db=db)

        return _api
