from aiohttp import web

from maps_adv.geosmb.tuner.server.lib.db.engine import DB
from maps_adv.geosmb.tuner.server.lib.domain import Domain

from .middlewares import handle_domain_errors, handle_validation_errors
from .resources import Resources

__all__ = ["create"]


def create(domain: Domain, db: DB) -> web.Application:
    api = web.Application(middlewares=[handle_validation_errors, handle_domain_errors])

    resources = Resources(domain, db=db)

    api.add_routes(
        [
            web.get("/ping", resources.ping),
            web.post("/v1/fetch_settings/", resources.fetch_settings),
            web.post("/v1/update_settings/", resources.update_settings),
            web.post("/v2/fetch_settings/", resources.fetch_settings_v2),
            web.post("/v2/update_settings/", resources.update_settings_v2),
            web.post(
                "/v1/fetch_settings/general_schedule_id/",
                resources.fetch_general_schedule_id_setting,
            ),
            web.post(
                "/v1/update_settings/general_schedule_id/",
                resources.update_general_schedule_id_setting,
            ),
            web.post("/v2/fetch_permissions/", resources.fetch_permissions),
            web.post("/v2/check_permission/", resources.check_permission),
            web.post("/v2/update_permission/", resources.update_permission),
            web.post("/v2/fetch_telegram_users/", resources.fetch_telegram_users),
            web.post("/v2/check_telegram_user/", resources.check_telegram_user),
            web.post("/v2/update_telegram_user/", resources.update_telegram_user),
            web.post("/v2/delete_telegram_user/", resources.delete_telegram_user),
        ]
    )

    return api
