from aiohttp.web import Request, Response, json_response

from maps_adv.geosmb.tuner.server.lib.db.engine import DB
from maps_adv.geosmb.tuner.server.lib.domain import Domain

from .providers import ApiProvider


class Resources:
    _provider: ApiProvider

    def __init__(self, domain: Domain, db: DB):
        self._provider = ApiProvider(domain)
        self._db = db

    async def ping(self, _: Request) -> Response:
        await self._db.healthcheck()

        return Response(status=204)

    async def fetch_settings(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.fetch_settings(data=body)

        return Response(status=200, body=result)

    async def update_settings(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.update_settings(data=body)

        return Response(status=200, body=result)

    async def fetch_settings_v2(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.fetch_settings_v2(data=body)

        return Response(status=200, body=result)

    async def update_settings_v2(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.update_settings_v2(data=body)

        return Response(status=200, body=result)

    async def fetch_general_schedule_id_setting(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.fetch_general_schedule_id_setting(data=body)

        return Response(status=200, body=result)

    async def update_general_schedule_id_setting(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.update_general_schedule_id_setting(data=body)

        return Response(status=200, body=result)

    async def fetch_permissions(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.fetch_permissions(data=body)

        return Response(status=200, body=result)

    async def check_permission(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.check_permission(data=body)

        return Response(status=200, body=result)

    async def update_permission(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.update_permission(data=body)

        return Response(status=200, body=result)

    async def fetch_telegram_users(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.fetch_telegram_users(data=body)

        return Response(status=200, body=result)

    async def check_telegram_user(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.check_telegram_user(data=body)

        return Response(status=200, body=result)

    async def update_telegram_user(self, request: Request) -> Response:
        body = await request.json()

        result = await self._provider.update_telegram_user(data=body)

        return json_response(result, status=200)

    async def delete_telegram_user(self, request: Request) -> Response:
        body = await request.json()

        await self._provider.delete_telegram_user(data=body)

        return Response(status=200)
