insert_settings = """
    INSERT INTO settings_data (
        biz_id,
        emails,
        phone,
        notifications,
        sms_notifications,
        booking_enabled,
        booking_slot_interval,
        booking_export_to_ya_services,
        requests_enabled,
        requests_button_text
    )
    VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10)
    ON CONFLICT (biz_id) DO UPDATE SET biz_id = $1
    RETURNING *
"""

insert_settings_v2 = """
    INSERT INTO settings_data (
        biz_id,
        contacts,
        notifications,
        sms_notifications,
        booking_enabled,
        booking_slot_interval,
        booking_export_to_ya_services,
        requests_enabled,
        requests_button_text
    )
    VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9)
    ON CONFLICT (biz_id) DO UPDATE SET biz_id = $1
    RETURNING *
"""

fetch_settings = """
    SELECT *
    FROM settings_data
    WHERE biz_id = $1
"""

fetch_permissions = """
    SELECT *
    FROM user_permissions
    WHERE biz_id = $1
"""

check_permission_for_user = """
    SELECT EXISTS(
        SELECT *
        FROM user_permissions
        WHERE biz_id = $1 and passport_uid = $2 and $3 = ANY(flags)
    )
"""

update_permission_for_user = """
    INSERT INTO user_permissions (
        biz_id,
        passport_uid,
        flags
    )
    VALUES ($1, $2, $3)
    ON CONFLICT (biz_id, passport_uid) DO UPDATE SET flags = $3
    RETURNING *
"""

fetch_telegram_users = """
    SELECT user_id, user_login
    FROM telegram_users_data
    WHERE user_login = ANY($1) AND active = true
"""

check_telegram_user = """
    SELECT EXISTS(
        SELECT 1
        FROM telegram_users_data
        WHERE user_login = $1
    )
"""

update_telegram_user = """
    INSERT INTO telegram_users_data (
        user_id,
        user_login
    )
    VALUES ($1, $2)
    ON CONFLICT (user_id) DO UPDATE SET user_login = $2, updated_at = NOW(), active = true
    RETURNING user_id, user_login
"""

delete_telegram_user = """
    UPDATE telegram_users_data
    SET active = false, updated_at = NOW()
    WHERE user_id = $1
"""
