PY3TEST()

OWNER(g:geosmb)

PEERDIR(
    contrib/python/pytest-asyncio

    smb/common/pgswim/pytest
    smb/common/testing_utils

    maps_adv/common/helpers
    maps_adv/common/lasagna/pytest
    maps_adv/geosmb/tuner/server
)

SRCDIR(maps_adv/geosmb/tuner/server)

PY_SRCS(
    __init__.py
    api/__init__.py
    domain/__init__.py
    data_manager/__init__.py
    conftest.py
    factory.py
)

TEST_SRCS(
    api/test_check_permission.py
    api/test_check_telegram_user.py
    api/test_delete_telegram_user.py
    api/test_fetch_general_schedule_id_setting.py
    api/test_fetch_permissions.py
    api/test_fetch_settings.py
    api/test_fetch_telegaram_users.py
    api/test_ping.py
    api/test_update_general_schedule_id_setting.py
    api/test_update_permission.py
    api/test_update_settings.py
    api/test_update_telegram_user.py
    data_manager/test_check_permission.py
    data_manager/test_check_settings_exist.py
    data_manager/test_check_telegram_user.py
    data_manager/test_create_default_settings.py
    data_manager/test_create_default_settings_v2.py
    data_manager/test_fetch_permissions.py
    data_manager/test_fetch_settings.py
    data_manager/test_fetch_telegaram_users.py
    data_manager/test_update_permission.py
    data_manager/test_update_settings.py
    data_manager/test_update_telegram_user.py
    domain/test_check_permission.py
    domain/test_check_telegram_user.py
    domain/test_delete_telegram_user.py
    domain/test_fetch_permissions.py
    domain/test_fetch_settings.py
    domain/test_fetch_settings_v2.py
    domain/test_fetch_telegaram_users.py
    domain/test_update_permission.py
    domain/test_update_settings.py
    domain/test_update_settings_v2.py
    domain/test_update_telegram_user.py
)

ENV(DATABASE_URL_FOR_TESTS=postgresql://tuner:tuner@localhost:5433/tuner?master_as_replica=true)
INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
)

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all
    dns:dns64
)

CONFTEST_LOAD_POLICY_LOCAL()

END()
