import argparse
import logging

from maps_adv.config_loader import Config
from maps_adv.manul.lib.application import Application


def main():
    logging.basicConfig(level=logging.DEBUG)

    args = parse_args()
    config = _prepare_config(args.config)

    run_app(args, config)


def _prepare_config(config_path) -> Config:
    _config = {
        "DATABASE_URL": {},
    }

    config = Config(_config)
    config.init(config_path)

    return config


def parse_args():
    parser = argparse.ArgumentParser("Manul")
    parser.add_argument("--host")
    parser.add_argument("--port", type=int)
    parser.add_argument("--config")

    return parser.parse_args()


def run_app(args, config: Config):
    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
