from aiohttp import web
from aiohttp.web import Request, Response

from maps_adv.manul.lib.api_providers import ClientsApiProvider


class Resources:
    _provider: ClientsApiProvider

    def __init__(self, provider: ClientsApiProvider):
        self._provider = provider

    async def create_client(self, request: Request) -> Response:
        body = await request.read()
        result = await self._provider.create_client(body)
        return web.Response(body=result, status=201)

    async def retrieve_client(self, request: Request) -> Response:
        client_id = request.match_info["client_id"]
        result = await self._provider.retrieve_client(client_id=int(client_id))
        return web.Response(body=result, status=200)

    async def update_client(self, request: Request) -> Response:
        client_id = request.match_info["client_id"]
        body = await request.read()
        result = await self._provider.update_client(body, client_id=int(client_id))
        return web.Response(body=result, status=200)

    async def set_account_manager_for_client(self, request: Request) -> Response:
        body = await request.read()
        await self._provider.set_account_manager_for_client(body)
        return web.Response(status=200)

    async def list_clients(self, request: Request) -> Response:
        result = await self._provider.list_clients()
        return web.Response(body=result, status=200)
