from aiohttp import web
from aiohttp.web import Request, Response

from maps_adv.manul.lib.api_providers import OrdersApiProvider


class Resources:
    _provider: OrdersApiProvider

    def __init__(self, provider: OrdersApiProvider):
        self._provider = provider

    async def create_order(self, request: Request) -> Response:
        body = await request.read()
        result = await self._provider.create_order(body)
        return web.Response(body=result, status=201)

    async def retrieve_order(self, request: Request) -> Response:
        order_id = request.match_info["order_id"]
        result = await self._provider.retrieve_order(order_id=int(order_id))
        return web.Response(body=result, status=200)

    async def update_order(self, request: Request) -> Response:
        raise NotImplementedError()

    async def list_orders(self, request: Request) -> Response:
        body = await request.read()
        result = await self._provider.list_orders(body)
        return web.Response(body=result, status=200)

    async def retrieve_order_ids_for_account(self, request: Request) -> Response:
        body = await request.read()
        result = await self._provider.retrieve_order_ids_for_account(body)
        return web.Response(body=result, status=200)
