"""empty message

Revision ID: 3eaa1f523b4c
Revises:
Create Date: 2019-11-13 13:15:52.379653

"""
import sqlalchemy as sa
from alembic import op

import maps_adv

# revision identifiers, used by Alembic.
revision = "3eaa1f523b4c"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "clients",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("name", sa.String(length=256), nullable=False),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_clients")),
        sa.UniqueConstraint("name", name=op.f("uq_clients_name")),
    )
    op.create_table(
        "orders",
        sa.Column("id", sa.BigInteger(), nullable=False),
        sa.Column("title", sa.String(length=256), nullable=False),
        sa.Column("comment", sa.String(length=1024), nullable=False),
        sa.Column("client_id", sa.BigInteger(), nullable=False),
        sa.Column("product_id", sa.BigInteger(), nullable=False),
        sa.Column(
            "currency",
            sa.Enum("RUB", "BYN", "TRY", "KZT", "EUR", "USD", name="currency_type"),
            nullable=False,
        ),
        sa.Column(
            "created_at",
            maps_adv.manul.lib.db.columns.DateTimeTZ(),
            server_default=sa.text("now()"),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["client_id"], ["clients.id"], name=op.f("fk_orders_client_id_clients")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_orders")),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("orders")
    op.drop_table("clients")

    op.execute("DROP TYPE currency_type;")
    # ### end Alembic commands ###
