import sqlalchemy as sa

from maps_adv.manul.lib.db.columns import Column, DateTimeTZ

from .enums import CurrencyType, RateType

_constaints_naming_convention = {
    "ix": "ix_%(column_0_label)s",
    "uq": "uq_%(table_name)s_%(column_0_name)s",
    "ck": "ck_%(table_name)s_%(constraint_name)s",
    "fk": "fk_%(table_name)s_%(column_0_name)s_%(referred_table_name)s",
    "pk": "pk_%(table_name)s",
}

metadata = sa.MetaData(naming_convention=_constaints_naming_convention)

clients = sa.Table(
    "clients",
    metadata,
    Column("id", sa.BigInteger, primary_key=True),
    Column("name", sa.String(length=256), unique=True),
    Column("account_manager_id", sa.BigInteger, nullable=True, index=True),
    Column("created_at", DateTimeTZ, server_default=sa.func.now(), index=True),
)

orders = sa.Table(
    "orders",
    metadata,
    Column("id", sa.BigInteger, primary_key=True),
    Column("title", sa.String(length=256)),
    Column("comment", sa.String(length=1024), default=""),
    Column("client_id", sa.BigInteger, sa.ForeignKey("clients.id")),
    Column("product_id", sa.BigInteger),
    Column("currency", sa.Enum(CurrencyType)),
    Column("created_at", DateTimeTZ, server_default=sa.func.now(), index=True),
    Column("rate", sa.Enum(RateType), server_default="PAID"),
)
