PY3TEST()

OWNER(g:maps-adv)

PEERDIR(
    maps_adv/manul

    maps_adv/common/pgswim

    contrib/python/pytest-asyncio
    contrib/python/pytest-mock
)

SRCDIR(maps_adv/manul)

PY_SRCS(
    __init__.py
    conftest.py
    api/__init__.py
    api_provider/__init__.py
    data_manager/__init__.py
)

TEST_SRCS(
    api/clients/test_create_client.py
    api/clients/test_list_clients.py
    api/clients/test_retrieve_client.py
    api/clients/test_update_client.py
    api/orders/test_create_order.py
    api/orders/test_retrieve_order.py
    api/orders/test_list_orders.py
    api/test_ping.py
    api_provider/clients/test_create_client.py
    api_provider/clients/test_list_clients.py
    api_provider/clients/test_retrieve_client.py
    api_provider/clients/test_update_client.py
    api_provider/orders/test_create_order.py
    api_provider/orders/test_retrieve_order.py
    api_provider/orders/test_list_orders.py
    data_manager/clients/test_create_client.py
    data_manager/clients/test_list_clients.py
    data_manager/clients/test_retrieve_client.py
    data_manager/clients/test_update_client.py
    data_manager/orders/test_create_order.py
    data_manager/orders/test_retrieve_order.py
    data_manager/orders/test_list_orders.py
)
ENV(DATABASE_URL_FOR_TESTS=postgresql://manul:manul@localhost:5433/manul)


INCLUDE(${ARCADIA_ROOT}/library/recipes/docker_compose/recipe.inc)

SIZE(LARGE)

TAG(
    ya:fat
    ya:force_sandbox
    ya:nofuse
    ya:sandbox_coverage
 )

REQUIREMENTS(
    container:773239891 # xenial
    cpu:all dns:dns64
)

END()
