PY3_LIBRARY()

OWNER(g:maps-adv)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/alembic
    contrib/python/sqlalchemy/sqlalchemy-1.2  # transition; see https://st.yandex-team.ru/CONTRIB-2042
    contrib/python/asyncpg
    contrib/python/marshmallow/py2
    contrib/python/psycopg2

    smb/common/multiruntime
    smb/common/pgswim

    maps_adv/common/pg_engine
    maps_adv/common/protomallow
    maps_adv/manul/proto
)

PY_SRCS(
    lib/__init__.py
    lib/application.py
    lib/api/__init__.py
    lib/api/middlewares.py
    lib/api/resources/__init__.py
    lib/api/resources/clients.py
    lib/api/resources/orders.py
    lib/api/resources/ping.py
    lib/api_providers/__init__.py
    lib/api_providers/clients.py
    lib/api_providers/orders.py
    lib/api_providers/schema_utils.py
    lib/data_managers/__init__.py
    lib/data_managers/clients.py
    lib/data_managers/exceptions.py
    lib/data_managers/orders.py
    lib/db/__init__.py
    lib/db/columns.py
    lib/db/engine.py
    lib/db/enums.py
    lib/db/tables.py
)

RESOURCE_FILES(
    PREFIX maps_adv/manul/
    alembic.ini
    lib/db/migrations/env.py
    lib/db/migrations/script.py.mako
    lib/db/migrations/versions/20191113_1315_3eaa1f523b4c.py
    lib/db/migrations/versions/20191121_1653_6621b0459417.py
    lib/db/migrations/versions/20191121_1805_9d4ca0314f07.py
    lib/db/migrations/versions/20200131_1207_39cc0296ee01.py
    lib/db/migrations/versions/20200417_1844_9e0d506d7a1e.py
)

END()

RECURSE_FOR_TESTS(tests)

RECURSE(app)
