from maps_adv.points.proto.errors_pb2 import Error


class PointsClientException(Exception):
    pass


class NotFound(PointsClientException):
    pass


class BadGateway(PointsClientException):
    pass


class ServiceUnavailable(PointsClientException):
    pass


class UnknownResponseCode(PointsClientException):
    def __init__(self, status_code: int, *args):
        super().__init__(f"Unknown response {status_code} from service points", *args)
        self.status_code = status_code


class UnknownResponseBody(Exception):
    def __init__(self, status_code: int, payload: bytes):
        super().__init__(f"Status={status_code}, payload={payload}")

        self.status_code = status_code
        self.payload = payload


class ValidationError(PointsClientException):
    pass


class InvalidVersion(PointsClientException):
    pass


class NoPointsPassed(PointsClientException):
    pass


class InvalidPolygon(PointsClientException):
    pass


class NonClosedPolygon(PointsClientException):
    pass


class NoPolygonsPassed(PointsClientException):
    pass


class CollectionNotFound(PointsClientException):
    pass


class UnknownError(PointsClientException):
    def __init__(self, status_code: int, error: Error):
        super().__init__(
            f"Status={status_code}, error_code={error.code}, "
            f"description={error.description}"
        )

        self.status_code = status_code
        self.error = error
