import argparse
import logging

from maps_adv.config_loader import Config
from maps_adv.points.server.lib import Application

_config = {
    "DATABASE_URL": {},
    "WARDEN_URL": {"default": None},
    "YT_TOKEN": {"default": None},
    "YT_FORECASTS_TABLE": {
        "default": "home/geodisplay/analytics/regular/adv_capacity/shows_predictions_geohash"
    },
    "YT_CLUSTER": {"default": "hahn"},
}

config = Config(_config)

parser = argparse.ArgumentParser("Points")
parser.add_argument("--host")
parser.add_argument("--port", type=int)
parser.add_argument("--config")


def main():
    logging.basicConfig(level=logging.DEBUG)

    args = parser.parse_args()
    config.init(args.config)

    app = Application(config)
    app.run(host=args.host, port=args.port)


if __name__ == "__main__":
    main()
