from aiohttp.web import Request, Response

from maps_adv.points.server.lib.api.providers import ForecastsApiProvider
from maps_adv.points.server.lib.data_managers import ForecastsDataManager

__all__ = ["ForecastsResources"]


class ForecastsResources:
    __slots__ = ("_provider",)

    _provider: ForecastsApiProvider

    def __init__(self, dm: ForecastsDataManager):
        self._provider = ForecastsApiProvider(dm)

    async def forecast_billboard(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.forecast_billboard(body)

        return Response(body=result, status=200)

    async def forecast_zerospeed(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.forecast_zerospeed(body)

        return Response(body=result, status=200)

    async def forecast_pins(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.forecast_pins(body)

        return Response(body=result, status=200)

    async def forecast_overview(self, request: Request) -> Response:
        body = await request.read()

        result = await self._provider.forecast_overview(body)

        return Response(body=result, status=200)
