from aiohttp.web import Request, Response

from maps_adv.points.server.lib.db import DB

__all__ = ["PingResources"]


class PingResources:
    __slots__ = ("_db",)

    _db: DB

    def __init__(self, db: DB):
        self._db = db

    async def ping(self, req: Request) -> Response:
        await self._db.healthcheck()
        return Response(status=200)
